// Animation: Erde und Mond  
// A. Filler, 2004
// Diese Animation veranschaulicht die Drehung der Erde um sich selbst, des 
// Mondes um die Erde und des Mondes um sich selbst.
// Die Grenverhltnisse von Erde und Mond sowie die Umlaufdauern wurden bercksichtigt.
// Der Abstand des Mondes zur Erde konnte nicht bercksichtigt werden, da ansonsten
// Erde und Mond viel zu klein dargestellt werden.
// Mittlere Entfernung Erde - Mond: ca. 384.000 km
// Erddurchmesser: ca.~12.700 km
// Monddurchmesser: ca.~3.500 km
// Dauer eines Umlaufes des Mondes um die Erde: ca.~27 Tage und 8 Stunden
// Dauer einer Drehung des Mondes um sich selbst: ebenfalls ca.~27 Tage und 8 Stunden
// HINWEIS: Um diese Datei als Video zu rendern, muss sich die Datei
//          Kameraflug1.ini IM SELBEN ORDNER BEFINDEN WIE DIESE
//          POV-RAY-DATEI. Gerendert werden muss die .ini-Datei, damit eine
//          Sequenz von Bildern fr ein Video entsteht.
// HINWEIS: Um diese Datei zu rendern, mssen sich die Texture-Maps
//          Erde+Mond-ErdMap.jpg und Erde+Mond-MondMap.jpg im selben Ordner
//          wie diese POV-Ray-Datei und die zugehrige .ini-Datei.
// ---------------------------------------------------------------
#version 3.5;                  // bentigte POV-Ray-Version
#include "colors.inc"
#include "textures.inc"
#include "stars.inc"

// Kamera
//-------
camera {
   location  <0, 50, -120>
   angle 30 
   look_at   <0, 0, 0>  }

// Lichtquellen
//-------------
light_source { <-250, 400, -250> color rgb<1,1,1> } // Hauptlicht (links, oben)
light_source { <-300, 100, -500> color rgb<0.35,0.35,0.35> } // (von hinten)
light_source { <-12, -3.5, 60> color rgb<0.5,0.5,0.5>} // Gegenlicht (vorn)

background {Black}


// ERDKUGEL
// --------
sphere {<0,0,0>, 12.75
 texture {
   pigment  {image_map { jpeg "ErdMap.jpg" map_type 1 } }
   finish { ambient rgb <0.6,0.6,0.9>  diffuse 0.3  phong 0.05 phong_size 15  }  }
 rotate <0, -90-360*clock*27, 0>
 translate <0,0,0>
 }


// MOND
// ----
sphere {<0,0,0>, 3.48
 texture {
   pigment  {image_map { jpeg "MondMap.jpg" map_type 1 } }
   finish { ambient 0.3  diffuse 0.6  phong 0.1 phong_size 15  }  }
 rotate <0, -360*clock, 0>
 translate <30,0,0>
 rotate <0, -360*clock, 0>
 no_shadow
 }
 